/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api;

import com.gitlab.srcmc.rctapi.api.battle.BattleManager;
import com.gitlab.srcmc.rctapi.api.events.EventContext;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class RCTApi {
    private TrainerRegistry trainerRegistry;
    private BattleManager battleManager;
    private EventContext eventContext;
    private static final EventContext DEFAULT_EVENT_CONTEXT = new EventContext();
    private static final RCTApi DEFEAULT_INSTANCE = new RCTApi(new TrainerRegistry("", DEFAULT_EVENT_CONTEXT), new BattleManager(DEFAULT_EVENT_CONTEXT), DEFAULT_EVENT_CONTEXT);
    private static Map<String, RCTApi> instances = new ConcurrentHashMap<String, RCTApi>();

    private RCTApi(TrainerRegistry trainerRegistry, BattleManager battleManager, EventContext eventContext) {
        this.trainerRegistry = trainerRegistry;
        this.battleManager = battleManager;
        this.eventContext = eventContext;
    }

    public TrainerRegistry getTrainerRegistry() {
        return this.trainerRegistry;
    }

    public BattleManager getBattleManager() {
        return this.battleManager;
    }

    public EventContext getEventContext() {
        return this.eventContext;
    }

    @Deprecated(since="0.10.5-beta")
    public static void init(TrainerRegistry trainerRegistry, BattleManager battleManager) {
    }

    @Deprecated(since="0.10.7-beta")
    public static RCTApi getInstance() {
        return DEFEAULT_INSTANCE;
    }

    public static RCTApi getInstance(String id) {
        return instances.getOrDefault(id, DEFEAULT_INSTANCE);
    }

    public static Stream<Map.Entry<String, RCTApi>> getInstances() {
        return Stream.concat(instances.entrySet().stream(), Stream.of(Map.entry("", DEFEAULT_INSTANCE)));
    }

    public static RCTApi initInstance(String id) {
        EventContext eventContext = new EventContext();
        return RCTApi.initInstance(id, new TrainerRegistry(id, eventContext), new BattleManager(eventContext), eventContext);
    }

    @Deprecated(since="0.10.7-beta")
    public static RCTApi initInstance(String id, TrainerRegistry trainerRegistry) {
        return RCTApi.initInstance(id, trainerRegistry, new BattleManager());
    }

    @Deprecated(since="0.10.7-beta")
    public static RCTApi initInstance(String id, TrainerRegistry trainerRegistry, BattleManager battleManager) {
        return instances.computeIfAbsent(id, s -> new RCTApi(trainerRegistry, battleManager, new EventContext()));
    }

    static RCTApi initInstance(String id, TrainerRegistry trainerRegistry, BattleManager battleManager, EventContext eventContext) {
        return instances.computeIfAbsent(id, s -> new RCTApi(trainerRegistry, battleManager, eventContext));
    }
}

